using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;
using Server.Spells;

namespace Server.Engines.XmlSpawner2
{
	public class XmlMeleeAbsorb : XmlAttachment
	{
		private int m_Absorb = 500;
		private TimeSpan m_Refractory = TimeSpan.FromSeconds( 120 );    // 5 seconds default time between activations
		private DateTime m_EndTime;
		private bool merc = false;                 // pouze pro marce

		[CommandProperty( AccessLevel.GameMaster )]
		public int Absorb { get{ return m_Absorb; } set { m_Absorb = Math.Max( value, 1 ); } }

		[CommandProperty( AccessLevel.GameMaster )]
		public bool Merc { get { return merc; } set { merc  = value; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public TimeSpan Refractory { get { return m_Refractory; } set { m_Refractory = value; } }

		// These are the various ways in which the message attachment can be constructed.
		// These can be called via the [addatt interface, via scripts, via the spawner ATTACH keyword.
		// Other overloads could be defined to handle other types of arguments

		// a serial constructor is REQUIRED
		public XmlMeleeAbsorb(ASerial serial) :  base(serial)
		{
		}

		[Attachable]
		public XmlMeleeAbsorb(int absorb)
		{
			m_Absorb = absorb;
		}

		[Attachable]
		public XmlMeleeAbsorb(int absorb, double refractory)
		{
			m_Absorb = absorb;
			Refractory = TimeSpan.FromSeconds(refractory);

		}
        
		[Attachable]
		public XmlMeleeAbsorb(int absorb, double refractory, double expiresin)
		{
			m_Absorb = absorb;
			Expiration = TimeSpan.FromMinutes(expiresin);
			Refractory = TimeSpan.FromSeconds(refractory);
		}


		// note that this method will be called when attached to either a mobile or a weapon
		// when attached to a weapon, only that weapon will do additional damage
		// when attached to a mobile, any weapon the mobile wields will do additional damage
		public override void OnWeaponHit(Mobile attacker, Mobile defender, BaseWeapon weapon, int damageGiven)
		{
			// if it is still refractory then return
			if( DateTime.Now < m_EndTime || attacker == null ) return;
			
			if( merc && !( attacker is Xanthos.Evo.Mercenary ) ) return;
			
			if ( attacker.MeleeDamageAbsorb > 0 )
			{
            m_EndTime = DateTime.Now + TimeSpan.FromSeconds( 60.0 );
            return;
         }
         
			attacker.MeleeDamageAbsorb += m_Absorb;
					
			attacker.FixedParticles( 0x375A, 10, 15, 5037, EffectLayer.Waist );
			attacker.PlaySound( 489 );
			attacker.Emote("*Invulnerability*");
			m_EndTime = DateTime.Now + Refractory;
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize(writer);

			writer.Write( (int) 0 );

			writer.Write(merc);
			writer.Write(m_Absorb);
			writer.Write(m_Refractory);
			writer.Write(m_EndTime - DateTime.Now);

		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
			switch(version)
			{
// 				case 1:
// 					// version 1
// 					Range = reader.ReadInt();
// 					goto case 0;
				case 0:
					// version 0
					merc = reader.ReadBool();
					m_Absorb = reader.ReadInt();
					Refractory = reader.ReadTimeSpan();
					TimeSpan remaining = reader.ReadTimeSpan();
					m_EndTime = DateTime.Now + remaining;
					break;
			}
		}

		public override string OnIdentify(Mobile from)
		{
			string msg = null;

			if(Expiration > TimeSpan.Zero)
			{
				msg = String.Format("{0} invulnerability points on hit. expires in {1} mins", m_Absorb, Expiration.TotalMinutes);
			} 
			else
			{
				msg = String.Format("{0} invulnerability points on hit",m_Absorb);
			}
			
			if ( merc )
				msg = msg + "\nMercenary only";
            
			if(Refractory > TimeSpan.Zero)
			{
				return String.Format("{0}\n{1} secs between uses",msg, Refractory.TotalSeconds);
			} 
			else
				return msg;
		}
		
		public override void OnAttach()
		{
			base.OnAttach();

			// announce it to the mob
			if(AttachedTo is Mobile)
			{
				if(m_Absorb > 0)
					((Mobile)AttachedTo).SendMessage("You have been granted the power of invulnerability!");
				else
					((Mobile)AttachedTo).SendMessage("You have been cursed with Life Drain!");
			}
		}
	}
}
